/*---------------------------------------------------------------------------*\

	FILE....: CONFIG.H
	TYPE....: C Header File
	AUTHOR..: David Rowe
	DATE....: 28/11/97

	Helper functions for talking to the VPB config manager.

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __CONFIG__
#define __CONFIG__

#include "contypes.h"
#include "comm.h"

#define	CONFIG_MAX_LIST		10

/*--------------------------------------------------------------------------*\

								FUNCTIONS

\*--------------------------------------------------------------------------*/

void config_create_object(Comm *c, USHORT board, USHORT cls, USHORT id, USHORT ch, USHORT data);
void config_create_wire(Comm *c, USHORT board, USHORT src, USHORT dest);
void config_clear(Comm *c, USHORT board);
void config_run(Comm *c, USHORT board);
void config_stop(Comm *c, USHORT board);
void config_clear_wire(Comm *c, USHORT board, USHORT obj);
void config_disable_object(Comm *c, USHORT board, USHORT obj);
void config_enable_object(Comm *c, USHORT board, USHORT obj);
void config_enable_two_objects(Comm *c, USHORT board, USHORT obj1, USHORT obj2);
void config_rate8k(Comm *c, USHORT board, USHORT obj);
void config_rate6k(Comm *c, USHORT board, USHORT obj);
void config_packrate(Comm *c, USHORT board, USHORT obj, USHORT packrate);
void config_adpcm_reset(Comm *c, USHORT board, USHORT obj);
void config_connect_to_zerobuf(Comm *c, USHORT board, USHORT obj);
void config_flush_fifo(Comm *c, USHORT board, USHORT obj);
void config_toneg_reset(Comm *c, USHORT board, USHORT obj);
void config_reset_fifo_alarm(Comm *c, USHORT board, USHORT obj);
void config_enable_object_list(Comm *c, USHORT board, USHORT objlist[], int nobj);

#endif	/* __CONFIG__ */
